package jamezo97.clonecraft.network;

import jamezo97.clonecraft.Logger;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.entity.clone.PlayerTeam;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class FieldValue {
	
	Field field;
	Handler handler;
	int id;
	
	boolean isArray = false;
	int type = -1;
	
	public FieldValue(Field field, Handler handler, int id){
		this.field = field;
		this.handler = handler;
		try{
			field.get(handler);
			Class classType = field.getType();
			if(classType.isArray()){
				isArray = true;
				if(classType.getComponentType() != null){
					if(classType.getComponentType().isArray()){
						Logger.error("Cannot have nested arrays in custom handler packets!");
						Logger.showLineOccured();
					}else{
						type = getTypeID(classType.getComponentType());
					}
				}else{
					Logger.error("The array doesn't have a type???");
					Logger.showLineOccured();
				}
			}else{
				type = getTypeID(field.getType());
			}
			
			if(type == -1){
				Logger.log("Unknown value: '" + field.getType() + "' from field '" + field.getName() + "' in class '" + field.getDeclaringClass() + "'");
				Logger.log("This value will not be written when sending this packet, and may cause some major issues...");
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		this.id = id;
	}
	
	public boolean setValue(Object o){
		try{
			field.set(handler, o);
			return true;
		}catch(Exception e){
			e.printStackTrace();
		}
		return false;
	}
	
	public Object getValue(){
		try{
			return field.get(handler);
		}catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}

	public Class getFieldClass(){
		return field.getType();
	}
	
	public static Object[] toOBJArray(Object array){
		int size = Array.getLength(array);
		Object[] values = new Object[size];
		for(int a = 0; a < size; a++){
			values[a] = Array.get(array, a);
		}
		return values;
	}
	
	public boolean write(DataOutputStream out)throws Exception{
		if(type == -1) return false;
		if(isArray){
			Object value = getValue();
			if(value != null){
				if(type > -1){
					out.write(id);
					Object[] array = toOBJArray(value);
					out.writeInt(array.length);
					for(int a = 0; a < array.length; a++){
						if(array[a] == null){
							out.write(0);
						}else{
							out.write(1);
							writeValue(out, type, array[a]);
						}
					}
					return true;
				}else if(type == -100){
					out.write(id);
					Object[] array = toOBJArray(value);
					out.writeInt(array.length);
					for(int a = 0; a < array.length; a++){
						if(array[a] == null){
							out.write(0);
						}else{
							int subType = getTypeID(array[a].getClass());
							if(subType > -1){
								out.write(1);
								out.write(subType);
								writeValue(out, subType, array[a]);
							}else{
								out.write(0);
							}
						}
					}
				}
			}
		}else{
			Object value = getValue();
			if(value != null){
				if(type > -1){
					out.write(id);
					writeValue(out, type, value);
					return true;
				}else if(type == -100){
					int newType = getTypeID(value.getClass());
					if(newType > -1){
						out.write(id);
						out.write(newType);
						writeValue(out, newType, value);
						return true;
					}
				}
			}
		}
		
		return false;
	}
	
	public static void writeValue(DataOutputStream out, int type, Object value)throws Exception{
		switch(type){
		case 0: out.writeBoolean((Boolean)value); break;
		case 1: out.writeByte((Byte)value); break;
		case 2: out.writeChar((Character)value); break;
		case 3: out.writeDouble((Double)value); break;
		case 4: out.writeFloat((Float)value); break;
		case 5: out.writeInt((Integer)value); break;
		case 6: out.writeLong((Long)value); break;
		case 7: out.writeShort((Short)value); break;
		case 8: out.writeUTF((String)value); break;
		case 9: CompressedStreamTools.write((NBTTagCompound)value, out); break;
		case 10: CompressedStreamTools.write(((ItemStack)value).writeToNBT(new NBTTagCompound()), out); break;
		case 11: out.writeInt(((PlayerTeam)value).teamID); break;
		case 12: out.writeInt(((Gene)value).getId()); break;
		}
	}
	
	public static void set(Field field, Object valueInstance, Object object)throws IllegalArgumentException, IllegalAccessException{
		field.set(valueInstance, object);
	}
	
	public boolean read(DataInputStream in)throws Exception{
		if(isArray){
			if(type > -1){
				int size = in.readInt();
				Class arrayType = field.getType();
				Object values = Array.newInstance(arrayType.getComponentType(), size);
				for(int a = 0; a < size; a++){
					if(in.read() == 1){
						Array.set(values, a, readValue(in, type));
					}
				}
				setValue(values);
				return true;
			}else{
				int size = in.readInt();
				Object[] values = new Object[size];
				for(int a = 0; a < size; a++){
					if(in.read() == 1){
						int subType = in.read();
						values[a] = readValue(in, subType);
					}
				}
				setValue(values);
			}
		}else{
			if(type > -1){
				try{
					setValue(in, field, handler, type);
					return true;
				}catch(Exception e){
					e.printStackTrace();
				}
				//Wow... wow again
			}else if(type == -100){
				//RAWR I DID IT AGAIN. Last time I did readInt, instead of read, 
				//which caused it to screw up, and here I am, doing it again!
				int typeFrom = in.read();
				try{
					setValue(in, field, handler, typeFrom);
					return true;
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}

		return false;
	}
	
	public static void setValue(DataInputStream in, Field field, Object valueInstance, int type)throws Exception{
		switch(type){
		case 0: set(field, valueInstance, in.readBoolean()); break;
		case 1: set(field, valueInstance, in.readByte()); break;
		case 2: set(field, valueInstance, in.readChar()); break;
		case 3: set(field, valueInstance, in.readDouble()); break;
		case 4: set(field, valueInstance, in.readFloat()); break;
		case 5: set(field, valueInstance, in.readInt()); break;
		case 6: set(field, valueInstance, in.readLong()); break;
		case 7: set(field, valueInstance, in.readShort()); break;
		case 8: set(field, valueInstance, in.readUTF()); break;
		case 9: set(field, valueInstance, CompressedStreamTools.read(in)); break;
		case 10: set(field, valueInstance, ItemStack.loadItemStackFromNBT(CompressedStreamTools.read(in))); break;
		case 11: set(field, valueInstance, PlayerTeam.getByID(in.readInt())); break;
		case 12: set(field, valueInstance, Gene.getGene(in.readInt())); break;
		}
	}
	
	public static Object readValue(DataInputStream in, int type)throws Exception{
		switch(type){
		case 0: return in.readBoolean();
		case 1: return in.readByte();
		case 2: return in.readChar();
		case 3: return in.readDouble();
		case 4: return in.readFloat();
		case 5: return in.readInt();
		case 6: return in.readLong();
		case 7: return in.readShort();
		case 8: return in.readUTF();
		case 9: return CompressedStreamTools.read(in);
		case 10: return ItemStack.loadItemStackFromNBT(CompressedStreamTools.read(in));
		case 11: return PlayerTeam.getByID(in.readInt());
		case 12: return Gene.getGene(in.readInt());
		}
		return null;
	}
	
/*	public static void readIntoArray(DataInputStream in, Object[] values, int type)throws Exception{
		switch(type){
		case 0: for(int i = 0; i < values.length; i++){values[i] = in.readBoolean();} break;
		case 1: for(int i = 0; i < values.length; i++){values[i] = in.readByte();} break;
		case 2: for(int i = 0; i < values.length; i++){values[i] = in.readChar();} break;
		case 3: for(int i = 0; i < values.length; i++){values[i] = in.readDouble();} break;
		case 4: for(int i = 0; i < values.length; i++){values[i] = in.readFloat();} break;
		case 5: for(int i = 0; i < values.length; i++){values[i] = in.readInt();} break;
		case 6: for(int i = 0; i < values.length; i++){values[i] = in.readLong();} break;
		case 7: for(int i = 0; i < values.length; i++){values[i] = in.readShort();} break;
		case 8: for(int i = 0; i < values.length; i++){values[i] = in.readUTF();} break;
		case 9: for(int i = 0; i < values.length; i++){values[i] = CompressedStreamTools.read(in);} break;
		case 10: for(int i = 0; i < values.length; i++){values[i] = ItemStack.loadItemStackFromNBT(CompressedStreamTools.read(in));} break;
		case 11: for(int i = 0; i < values.length; i++){values[i] = PlayerTeam.getByID(in.readInt());} break;
		}
	}*/
	
	
	static HashMap<Class, Integer> classToID = new HashMap<Class, Integer>();
	
	static HashMap<Integer, Class> IDToClass = new HashMap<Integer, Class>();
	
	static void registerType(Class type, int id){
		classToID.put(type, id);
		IDToClass.put(id, type);
	}
	
	public static Class getTypeClass(int typeID){
		if(typeID != -1 && IDToClass.containsKey(typeID)){
			return IDToClass.get(typeID);
		}
		return null;
	}
	
	public static int getTypeID(Class typeClass){
		if(typeClass != null && classToID.containsKey(typeClass)){
			return classToID.get(typeClass);
		}
		return -1;
	}
	
	static{
		registerType(Boolean.class, 0);
		registerType(boolean.class, 0);
		registerType(Byte.class, 1);
		registerType(byte.class, 1);
		registerType(Character.class, 2);
		registerType(char.class, 2);
		registerType(Double.class, 3);
		registerType(double.class, 3);
		registerType(Float.class, 4);
		registerType(float.class, 4);
		registerType(Integer.class, 5);
		registerType(int.class, 5);
		registerType(Long.class, 6);
		registerType(long.class, 6);
		registerType(Short.class, 7);
		registerType(short.class, 7);
		registerType(String.class, 8);
		registerType(NBTTagCompound.class, 9);
		registerType(ItemStack.class, 10);
		registerType(PlayerTeam.class, 11);
		registerType(Gene.class, 12);
		registerType(Vec3.class, 13);
		registerType(Object.class, -100);
	}

}
